% getparams.m
% 
% generates a parameter vector
% 
% Estimating Macroeconomic Models of Financial Crises: An Endogenous Regime-Switching Approach*
%   Gianluca Benigno, Andrew Foerster, Christopher Otrok, Alessandro Rebucci
% 
% Updated July 2024
% % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % %
% 
% INPUTS:   GLOBALS = a structure with many elements for parameters,
%                   system dimensions, and options
% 
% OUTPUTS:  THETA   = a vector of parameters
% 
% % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % % %
function THETA = getparams(GLOBALS)

parm_ind = GLOBALS.parm_ind;

THETA = NaN(numel(fieldnames(parm_ind)),1);

% preferences and production
THETA(parm_ind.iiota)           = 10;
THETA(parm_ind.pphi)            = 0.7;
THETA(parm_ind.rbar)            = 0.0177;
THETA(parm_ind.kkappa)          = 0.2;

% persistences of exogenous processes
THETA(parm_ind.rrhoa)           = 0.9;
THETA(parm_ind.rrhoz)           = 0.9;
THETA(parm_ind.rrhop)           = 0.9;
THETA(parm_ind.rrhor)           = 0.9;
THETA(parm_ind.rrhoe)           = 0.9;
THETA(parm_ind.rrhod)           = 0.9;

% volatilities of exogenous processes
THETA(parm_ind.ssigmaa_l)       = 0.005;
THETA(parm_ind.ssigmaa_h)       = 0.005;
THETA(parm_ind.ssigmaz_l)       = 0.005;
THETA(parm_ind.ssigmaz_h)       = 0.005;
THETA(parm_ind.ssigmap_l)       = 0.05;
THETA(parm_ind.ssigmap_h)       = 0.05;
THETA(parm_ind.ssigmar_l)       = 0.01;
THETA(parm_ind.ssigmar_h)       = 0.01;
THETA(parm_ind.ssigmae_l)       = 0.5;
THETA(parm_ind.ssigmae_h)       = 0.5;
THETA(parm_ind.ssigmad_l)       = 0.05;
THETA(parm_ind.ssigmad_h)       = 0.05;

% transition probability parameters
THETA(parm_ind.p01)             = 0.5;
THETA(parm_ind.p10)             = 0.5;
THETA(parm_ind.psigma_ll)       = 0.975;
THETA(parm_ind.psigma_hh)       = 0.975;




end